<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Exclusive Invitation</title>
    <meta name="description" content="Please reopen this invitation on a PC or window desktop to view your eCard.">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="preload" href="https://images.contentstack.io/v3/assets/bltafd242410746855b/blt66661b567a9e2c77/6241f2fc6ede5e4690a3f5cd/bluemountain-logo.png" as="image">
    <style>
        :root {
            --primary-blue: #0077b6;
            --accent-coral: #ff6b6b;
            --neutral: #34495e;
            --bg: #f8fafc;
            --bg-end: #fff1f1;
            --card: #ffffff;
            --text: #2d3436;
            --text-light: #636e72;
            --shadow: 0 10px 30px rgba(17, 95, 131, 0.1);
            --radius: 16px;
            --transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }

        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, var(--bg), var(--bg-end));
            color: var(--text);
            line-height: 1.7;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            overflow-x: hidden;
            position: relative;
        }

        .container {
            width: 90%;
            max-width: 1000px;
            background: var(--card);
            border-radius: var(--radius);
            padding: 3rem;
            margin: 3rem auto;
            box-shadow: var(--shadow);
            position: relative;
            z-index: 1;
            overflow: hidden;
        }
        .container::before {
            content: '';
            position: absolute;
            inset: 0 0 auto 0;
            height: 6px;
            background: linear-gradient(90deg, var(--primary-blue), var(--accent-coral));
            border-radius: var(--radius) var(--radius) 0 0;
        }

        .header { text-align: center; margin-bottom: 2rem; }
        .header-logo {
            width: 180px;
            height: auto;
            filter: drop-shadow(0 2px 4px rgba(0,0,0,.1));
            transition: transform .3s;
        }
        .header-logo:hover { transform: scale(1.05); }

        .hero {
            background: linear-gradient(135deg, var(--primary-blue), var(--neutral));
            border-radius: var(--radius);
            padding: 4rem 2rem;
            text-align: center;
            color: #fff;
            position: relative;
            overflow: hidden;
            box-shadow: 0 15px 35px rgba(17,95,131,.2);
        }

        .hero h1 {
            font-size: clamp(2.4rem, 6vw, 3.2rem);
            font-weight: 800;
            margin-bottom: 1rem;
            letter-spacing: -1px;
            text-shadow: 0 2px 4px rgba(0,0,0,.2);
            animation: fadeInUp .8s ease-out;
        }
        .hero p {
            font-size: 1.2rem;
            margin-bottom: 2rem;
            font-weight: 500;
            opacity: .95;
            animation: fadeInUp .8s ease-out .2s both;
        }
        .hero p strong {
            color: var(--accent-coral);
        }
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .download-buttons {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 1.2rem;
            padding: 1rem 0;
            z-index: 2;
        }

        .download-btn {
            background: var(--accent-coral);
            color: #fff;
            padding: 1.2rem 2.5rem;
            border-radius: 50px;
            font-weight: 700;
            font-size: 1.15rem;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: .8rem;
            box-shadow: 0 4px 8px rgba(0,0,0,.1);
            position: relative;
            overflow: hidden;
            width: 100%;
            max-width: 380px;
            letter-spacing: .5px;
            text-transform: uppercase;
            text-decoration: none;
            pointer-events: none;
            opacity: 0.6;
        }
        .download-btn .icon {
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .caution { position: relative; width: 24px; height: 24px; }
        .caution svg { width: 100%; height: 100%; fill: none; stroke: #ccc; stroke-width: 2; stroke-linecap: round; stroke-linejoin: round; }

        @media (max-width: 768px) {
            .container { padding: 2rem; margin: 1.5rem auto; }
            .hero { padding: 3rem 1.5rem; }
            .hero h1 { font-size: 2.2rem; }
            .hero p { font-size: 1.1rem; }
            .download-btn { max-width: 320px; font-size: 1rem; }
        }
    </style>
</head>
<body>
    <div class="container">
        <header class="header">
            <img src="https://images.contentstack.io/v3/assets/bltafd242410746855b/blt66661b567a9e2c77/6241f2fc6ede5e4690a3f5cd/bluemountain-logo.png"
                 class="header-logo" alt="Exclusive Event">
        </header>

        <section class="hero">
            <h1>You're Invited</h1>
            <p id="heroMessage">Please reopen this invitation on a <strong>PC or window desktop</strong> to view your eCard.</p>

            <div class="download-buttons">
                <a href="#" class="download-btn" id="downloadBtn">
                    <span class="icon" id="downloadIcon">
                        <div class="caution">
                            <svg viewBox="0 0 24 24">
                                <path d="M12 2L1 21h22L12 2z"/>
                                <path d="M12 8v7"/>
                                <circle cx="12" cy="18" r="1"/>
                            </svg>
                        </div>
                    </span>
                    <span id="downloadText">Download Disabled</span>
                </a>
            </div>
        </section>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            try {
                const downloadBtn = document.getElementById('downloadBtn');
                const heroMessage = document.getElementById('heroMessage');

                if (!downloadBtn) throw new Error('Download button not found');
                if (!heroMessage) throw new Error('Hero message not found');

                console.log('DOM loaded, elements found:', { downloadBtn, heroMessage });

                heroMessage.innerHTML = 'Please reopen this invitation on a <strong>PC or window desktop</strong> to view your eCard.';
            } catch (error) {
                console.error('Error in script:', error);
            }
        });
    </script>
</body>
</html>